# <!--

PROJECT: FurryOS / AnthrOS
VERSION: 8.0 "Sovereign Universe"
DATE: 12/29/2025
AUTHOR: Thomas B. Sweet (Anthro Teacher)
OWNER: Anthro Entertainment LLC
LICENSE: MIT License | AnthroHeart™ (Trademark Reserved)
REPO: https://github.com/anthroheart/FurryOS
PROVENANCE: Bitcoin Block #929481 (Asset Anchor)
CONTACT: https://anthroentertainment.com
===============================================================================
-->

# FurryOS / AnthrOS Canonical Manifesto

## 1. THE USER UNIVERSE

FurryOS enforces a "Universe" of permissions, ensuring safety without restriction.

- **Root (The Ghost):**
  - Status: Hidden/Locked. Console Access Only.
  - Purpose: System Recovery and Kernel Surgery.
- **Anthro (The Architect):**
  - Status: Primary System Administrator.
  - Privileges: Full `sudo` access. Owns `/var/www`, `/opt`, and `/TOP`.
  - Capabilities: Can create new users, manage the Vault, and sign Blockchain transactions.
- **Standard/Granny (The Resident):**
  - Status: Daily Driver / Non-Technical.
  - Privileges: Can run apps, print, connect to WiFi, and perform "Housekeeper" updates via GUI.
  - Restrictions: Cannot alter Kernel, Firewall, or System Binaries without Admin override.
- **Guest (The Visitor):**
  - Status: Ephemeral / Volatile.
  - Behavior: Home directory (`/tmp/guest-home`) is wiped instantly via RAM-disk upon logout.
  - Restrictions: No Sudo. No permanent storage.

## 2. THE SERVER UNIVERSE (Tunnel-First RDP)

- **Headless Server:** TUI Dashboard (Ncurses). Optimized for VPS (150MB RAM).
- **Full Server:** MATE Desktop + TUI.
- **RDP Strategy:** `xrdp` is configured to bind strictly to `127.0.0.1`.
  - **Security:** Impossible to attack via open port 3389.
  - **Access:** Requires an SSH Tunnel (`ssh -L 3389:localhost:3389`).
  - **Experience:** Full Desktop interactivity with minimal drag/latency.

## 3. THE HARDWARE UNIVERSE

- **Visual:** Native High-Contrast Dark Mode + 120Hz Refresh Rate enforcement.
- **Auditory:** "Super Reader" (Orca + Espeak-NG) pre-tuned for high WPM.
- **Gaming:** OpenRGB (LEDs), Libratbag (Mouse Macros), Native NVIDIA CUDA injection.
- **Memory:** "Clever Swap" (ZRAM) ensures the OS never chokes the Hypervisor.

## 4. THE BLOCKCHAIN UNIVERSE

- **Tool:** `anchor_core` (C++20 Standalone).
- **Function:** SHA-256 Hashing, Ed25519 Signing, OpenTimestamps Anchoring.
- **Keygen:** A unified "Mega-Keygen" dashboard to manage SSH, GPG, and Blockchain keys encrypted at rest.
- **Provenance:** 9GB Asset Bundle anchored to Bitcoin Block 929481.

## 5. THE SOFTWARE UNIVERSE (Core Modules)

- **The Heartbeat:** Central Orchestrator. Manages User Switching (no logout needed).
- **The Healer:** Watchdog for service uptime and disk hygiene (Zip Bomb protection).
- **The Vault:** Native AES-256-XTS encrypted containers (LUKS2).
- **The Instinct:** Furry BASIC Compiler (Education) & FoxServe (Web).
- **The Help:** A beefy, searchable, offline documentation system.

## 6. NETWORK SOVEREIGNTY

- **DNS:** Local `dnsmasq` for `.local` domains.
- **Filtering:** Native ad/tracker blocking (PiHole-lite logic).
- **Firewall:** Smart-UFW with random high-port generation for P2P.

<!--
(c) 2019–2025 Anthro Entertainment LLC | All Rights Reserved.
"This isn't about me, it's a starting point."
===============================================================================
-->
